local super = require "View"

Rectangle = super:new()

local defaults = {
    thickness = 2,
}

local nilDefaults = {
}

local inspectorInfo = {
    {'Stroke', {'thickness'}, nil, 'Thickness'},
}

function Rectangle:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function Rectangle:unarchiveFill(archived)
    -- NOTE: Version 1.3.2 and earlier stored rectangle fill colors separately from the color scheme.
    self._legacyFill = unarchive(archived)
end

function Rectangle:unarchiveStroke(archived)
    -- NOTE: Version 1.3.2 and earlier stored rectangle stroke colors separately from the color scheme.
    self._legacyStroke = unarchive(archived)
end

function Rectangle:unarchived()
    if self._legacyFill then
        self:setPaint(ColorScheme.backgroundPaint, self._legacyFill)
    end
    if self._legacyStroke then
        self:setPaint(ColorScheme.strokePaint, self._legacyStroke)
    end
    super.unarchived(self)
end

function Rectangle:getInspectors()
    local list = super.getInspectors(self)
    list:add(self:createColorInspector(ColorScheme.backgroundPaint, nil, 'Fill'))
    list:add(self:createColorInspector(ColorScheme.strokePaint, nil, 'Stroke'))
    for i = 1, #inspectorInfo do
        local info = inspectorInfo[i]
        list:add(self:createInspector(unpack(info)))
    end
    return list
end

function Rectangle:padding()
    local thickness = self:getProperty('thickness')
    return {
        left = thickness/2,
        bottom = thickness/2,
        right = thickness/2,
        top = thickness/2,
    }
end

function Rectangle:draw(canvas)
    local fill = self:getPaint(ColorScheme.backgroundPaint)
    local stroke = self:getPaint(ColorScheme.strokePaint)
    local thickness = self:getProperty('thickness')
    local path = Path.rect(self:rect())
    canvas:setPaint(fill):fill(path)
    canvas:setThickness(thickness):setPaint(stroke):stroke(path)
end

return Rectangle
